//
//  RepliesIOScreenRecordingWindowController.h
//  RepliesSDK
//
//  Created by Stefan Fuerst on 07.07.16.
//  Copyright (c) 2016 Replies. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <AVFoundation/AVFoundation.h>


@class RepliesIOScreenRecorder;
@class RepliesIOScreenRecorderBackgroundView;
@class RepliesIOScreenRecorderViewFinderView;
@class RepliesIOAttachment;
@class RepliesIOWindowController;

@protocol RepliesIOScreenRecorderDelegate;


@interface RepliesIOScreenRecordingWindowController : NSWindowController <NSWindowDelegate,AVCaptureFileOutputDelegate>

@property (nonatomic,assign) IBOutlet RepliesIOScreenRecorderViewFinderView * viewFinderView;
@property (nonatomic,assign) IBOutlet RepliesIOScreenRecorderBackgroundView * backgroundView;

@property (nonatomic,strong) RepliesIOScreenRecorder * recorder;
@property (nonatomic,strong) id localMonitor;
@property (nonatomic,strong) id globalMonitor;
@property (nonatomic,strong) NSSound * shutter;
@property (nonatomic,assign) BOOL capturing;
@property (nonatomic,assign) id <RepliesIOScreenRecorderDelegate> delegate;
@property (nonatomic,assign) RepliesIOWindowController * parentWindowController;




@end


@protocol RepliesIOScreenRecorderDelegate

@optional
-(void)screenRecorderCancelScreenRecording:(RepliesIOScreenRecordingWindowController *)controller;
-(void)screenRecorder:(RepliesIOScreenRecordingWindowController *)controller addAttachment:(RepliesIOAttachment *)aAttachment;

@end