#!/bin/bash

now=$(date +%Y%m%d-%H%M%S)

XAPP_TITLE=$APP_TITLE
XAPP_NAME=$APP_ID
XAPP_WEBSITE_LOCAL="/Users/dirk/work/receipts-web"
XAPP_BUILDS_LOCAL="$XAPP_WEBSITE_LOCAL/builds/download/"
XAPP_BUILDS_REMOTE="cyon:public_html/receipts-app-2.com/download/"
XAPP_SENTRY_NAME=$APP_ID

VOICE=Claire

### EXPORT FOLDER & VARS

EXPORT_PATH="/Users/dirk/builds/$XAPP_TITLE-$APP_VERSION-$APP_BUILD-$now"
APP_PATH="$EXPORT_PATH/$PRODUCT_NAME.app"
ZIP_PATH="$EXPORT_PATH/$PRODUCT_NAME.zip"
XZIP_PATH="$EXPORT_PATH/$PRODUCT_NAME-$APP_VERSION-$APP_BUILD.zip"
XREADME_PATH="$XAPP_BUILDS_LOCAL$PRODUCT_NAME-$APP_VERSION.md"

### Logging

mkdir -p $EXPORT_PATH
log="$EXPORT_PATH/archive-$now.log"
exec > $log 2>&1
echo "Start $XAPP_TITLE"

set -e
set -x
set -o xtrace

export

open $log

/usr/bin/osascript -e "display notification \"Prepare Notarize $XAPP_TITLE\" with title \"$XAPP_TITLE\""

### Voice

say -v $VOICE "Los geht's!" &

### README

touch "$XREADME_PATH"
open "$XREADME_PATH"

### BUILD

/usr/bin/xcodebuild -allowProvisioningUpdates -exportArchive -archivePath "$ARCHIVE_PATH" -exportOptionsPlist "$SRCROOT/ExportOptions.plist" -exportPath "$EXPORT_PATH"

# As a convenience, open the export folder in Finder.
#/usr/bin/open "$EXPORT_PATH"

### NOTARIZE

# App specific password: bzka-ndvn-eurb-xbmq
# Team ID: 8SS3YPUJH9

echo ""
echo "NOTARIZATION begins, please wait until finished! May take very very long!"

# Zip für notarytool erstellen
/usr/bin/ditto -c -k --keepParent --sequesterRsrc --noacl --noextattr --nocache "$APP_PATH" "$ZIP_PATH"

# Notarisierung durchführen und warten
say -v $VOICE "Notarisierung wird gestartet. Bitte warten..." &
/usr/bin/osascript -e "display notification \"$XAPP_TITLE: Notarisierung...\""
xcrun notarytool submit "$ZIP_PATH" --keychain-profile "AC_NOTARY" --wait

### DISTRIBUTION

# Zip erzeugen, dass verteilt werden kann

xcrun stapler staple -v "$APP_PATH"
/usr/bin/ditto -c -k --keepParent --sequesterRsrc --noacl --noextattr --nocache "$APP_PATH" "$XZIP_PATH"

# Zip an die richtigen Stellen kopieren / uploaden

cp "$XZIP_PATH" $XAPP_BUILDS_LOCAL
scp "$XZIP_PATH" $XAPP_BUILDS_REMOTE

# Website aktualisieren

/usr/local/bin/code "$XAPP_WEBSITE_LOCAL"
# /usr/bin/open -a Firefox "https://viidoo.space/downloads/macos/admin"
say -v $VOICE "Fertig. Jetzt kannst du die Website aktualisieren."

### SENTRY UPLOAD

# See https://github.com/getsentry/sentry-cli#homebrew
export PATH="/opt/homebrew/bin:$PATH"

if which sentry-cli >/dev/null; then
  export SENTRY_ORG=holtwick
  export SENTRY_PROJECT=$XAPP_SENTRY_NAME
  export SENTRY_AUTH_TOKEN=d7ce2ac5d5a14865a95934ee611e4c0b565ea696a2a64810865dd2553449123d
  export SENTRY_LOG_LEVEL=info
  export SENTRY_VERSION="${PRODUCT_BUNDLE_IDENTIFIER}@${APP_VERSION}+${APP_BUILD}"

  sentry-cli releases new $SENTRY_VERSION

  # ERROR=$(sentry-cli upload-dif "$ARCHIVE_DSYMS_PATH" 2>&1 >/dev/null)
  ERROR=$(sentry-cli upload-dif "$DWARF_DSYM_FOLDER_PATH" 2>&1 >/dev/null)
  if [ ! $? -eq 0 ]; then
    echo "warning: sentry-cli - $ERROR"
    say -v $VOICE "Achtung! Beim Upload zu Sentry ist etwas schief gelaufen."
  fi    
else
  echo "warning: sentry-cli not installed, download from https://github.com/getsentry/sentry-cli/releases"
  say -v $VOICE "Achtung! Das Sentry Tool ist nicht installiert!"
fi

say -v $VOICE "Alles erledigt, alle Fenster können geschlossen werden."
